//
//  OPSwordWood.m
//  The Obfuscated Path
//
//  Created by ss2cire on 1/29/09.
//  Copyright 2009 GryphonClaw Software. All rights reserved.
//

#import "OPWoodSword.h"
#import "OPTextureManager.h"

@implementation OPWoodSword
- (id)initWithType:(NSString *)inType
{
	self = [super initWithType:inType];
	if(self != nil) {
		textures = [[NSMutableDictionary alloc] init];
		NSNumber *theID;
		u_int	texID = 0;
		NSDictionary *swordTextures = [NSArray arrayWithObjects:@"Sword_Wood_Down", @"Sword_Wood_Up", @"Sword_Wood_Left", @"Sword_Wood_Right", nil];
		NSEnumerator *enumerator = [swordTextures objectEnumerator];
		id textureName;
		while((textureName = [enumerator nextObject]) != nil) {
			texID = [[OPTextureManager sharedManager] textureWithName:textureName];
			theID = [NSNumber numberWithUnsignedInt:texID];
			[textures setObject:theID forKey:textureName];
		}
		attackPower = 1;
		textureID = [theID unsignedIntValue];
		swordDirection = OPUp;
	}
	return self;
}

- (void)setSwordDirection:(OPDirection)theDirection
{
	switch(theDirection) {
		case OPUp:
			textureID = [[textures objectForKey:@"Sword_Wood_Up"] unsignedIntValue];
			swordDirection = OPUp;
			break;
		case OPDown:
			textureID = [[textures objectForKey:@"Sword_Wood_Down"] unsignedIntValue];
			swordDirection = OPDown;
			break;
		case OPRight:
			textureID = [[textures objectForKey:@"Sword_Wood_Right"] unsignedIntValue];
			swordDirection = OPRight;
			break;
		case OPLeft:
			textureID = [[textures objectForKey:@"Sword_Wood_Left"] unsignedIntValue];
			swordDirection = OPLeft;
			break;
		default:
			textureID = 0;
			NSLog(@"OPWoodSword Invalid direction: %i", theDirection);
			break;
	}
}

- (OPRect)collisionRect
{
	OPRect theRect = NSZeroRect;
	switch(swordDirection) {
		case OPUp:
			theRect = OPMakeRect(location.x + 12,location.y + 16,9,16);
			break;
		case OPDown:
			theRect = OPMakeRect(location.x + 11,location.y,9,16);
			break;
		case OPRight:
			theRect = OPMakeRect(location.x + 12, location.y + 11, 20, 9);
			break;
		case OPLeft:
			theRect = OPMakeRect(location.x - 2, location.y + 12, 20, 9);
			break;
		default:
			break;
	}
	return theRect;
}

- (void)draw
{
	/*OPRect collisionRect = [self collisionRect];
	glBegin(GL_LINE_LOOP); {
		glColor3d(1, 0, 0);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y);
		glVertex2d(collisionRect.origin.x + collisionRect.size.width, collisionRect.origin.y + collisionRect.size.height);
		glVertex2d(collisionRect.origin.x, collisionRect.origin.y + collisionRect.size.height);
		glColor3d(1.0, 1.0, 1.0);
	}
	glEnd();*/
	[super draw];
	
}

- (void)drawIcon
{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, [[textures objectForKey:@"Sword_Wood_Up"] unsignedIntValue]);
	
	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 1.0);
	glVertex2i(0.0, 0.0);
	
	glTexCoord2f(0.0, 0.0);
	glVertex2i(0.0, 0.0 + size.height);
	
	glTexCoord2f(1.0, 0.0);
	glVertex2i(0.0 + size.width, 0.0 + size.height);
	
	glTexCoord2f(1.0, 1.0);
	glVertex2i(0.0 + size.width, 0.0);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}
@end
